from flask import Flask, request, jsonify
import base64, io, json
from PIL import Image
import numpy as np
import face_recognition
import mysql.connector

app = Flask(__name__)

db = mysql.connector.connect(host='127.0.0.1', user='dbuser', password='dbpass', database='auth_demo')

def decode_dataurl(durl):
    if ',' in durl:
        header, data = durl.split(',',1)
    else:
        data = durl
    return base64.b64decode(data)

@app.route('/register', methods=['POST'])
def register():
    body = request.get_json()
    username = body.get('username')
    image = body.get('image')
    if not username or not image:
        return jsonify({'success':False,'error':'missing params'}),400

    cursor = db.cursor(dictionary=True)
    cursor.execute("SELECT id FROM users WHERE username=%s", (username,))
    user = cursor.fetchone()
    if not user:
        return jsonify({'success':False,'error':'no such user'}),400
    user_id = user['id']

    imgbytes = decode_dataurl(image)
    img = Image.open(io.BytesIO(imgbytes)).convert('RGB')
    arr = np.array(img)
    encs = face_recognition.face_encodings(arr)
    if not encs:
        return jsonify({'success':False,'error':'no face found'}),400
    enc = encs[0].tolist()

    cursor2 = db.cursor()
    cursor2.execute("INSERT INTO face_embeddings (user_id, embedding, source) VALUES (%s, %s, %s)",
                    (user_id, json.dumps(enc), 'web'))
    db.commit()
    return jsonify({'success':True})

@app.route('/verify', methods=['POST'])
def verify():
    body = request.get_json()
    image = body.get('image')
    username = body.get('username')
    if not image:
        return jsonify({'success':False,'error':'missing image'}),400

    imgbytes = decode_dataurl(image)
    img = Image.open(io.BytesIO(imgbytes)).convert('RGB')
    arr = np.array(img)
    encs = face_recognition.face_encodings(arr)
    if not encs:
        return jsonify({'success':False,'error':'no face found'}, 400)
    probe = np.array(encs[0])

    cursor = db.cursor(dictionary=True)
    if username:
        cursor.execute("SELECT fe.user_id, fe.embedding FROM face_embeddings fe JOIN users u ON u.id=fe.user_id WHERE u.username=%s", (username,))
    else:
        cursor.execute("SELECT user_id, embedding FROM face_embeddings")
    rows = cursor.fetchall()
    best = None
    for r in rows:
        emb = np.array(json.loads(r['embedding']))
        dist = np.linalg.norm(emb - probe)
        if best is None or dist < best['dist']:
            best = {'user_id': r['user_id'], 'dist': float(dist)}
    if best and best['dist'] < 0.60:
        return jsonify({'success':True, 'user_id': int(best['user_id']), 'distance': best['dist']})
    return jsonify({'success':False,'matched':False})

if __name__ == '__main__':
    app.run(host='0.0.0.0', port=5000, debug=True)
