<?php
require_once __DIR__ . '/../includes/session.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/functions.php';

$body = json_decode(file_get_contents('php://input'), true);
if(!$body || empty($body['username'])) json_out(['success'=>false,'error'=>'missing username']);

$username = trim($body['username']);
$displayName = $body['displayName'] ?? $username;

// find or create user
$stmt = $pdo->prepare("SELECT id FROM users WHERE username = ?");
$stmt->execute([$username]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);
if(!$user){
  $ins = $pdo->prepare("INSERT INTO users (username, display_name) VALUES (?,?)");
  $ins->execute([$username, $displayName]);
  $userId = $pdo->lastInsertId();
} else {
  $userId = $user['id'];
}

$challenge = random_bytes(32);
$_SESSION['webauthn_challenge'] = base64url_encode($challenge);
$_SESSION['webauthn_user'] = $userId;

$options = [
  'rp' => ['name' => 'AuthDemo', 'id' => $_SERVER['SERVER_NAME']],
  'user' => ['id' => base64url_encode(pack('N', $userId)), 'name' => $username, 'displayName' => $displayName],
  'challenge' => base64url_encode($challenge),
  'pubKeyCredParams' => [['type'=>'public-key','alg'=>-7], ['type'=>'public-key','alg'=>-257]],
  'timeout' => 60000,
  'attestation' => 'none'
];

// exclude existing creds
$stmt2 = $pdo->prepare("SELECT cred_id FROM webauthn_credentials WHERE user_id = ?");
$stmt2->execute([$userId]);
$rows = $stmt2->fetchAll(PDO::FETCH_ASSOC);
$exclude = [];
foreach($rows as $r){
  $exclude[] = ['type'=>'public-key','id'=>base64url_encode($r['cred_id'])];
}
if(!empty($exclude)) $options['excludeCredentials'] = $exclude;

json_out(['success'=>true,'options'=>$options]);
