<?php
require_once __DIR__ . '/../includes/session.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/functions.php';

$body = json_decode(file_get_contents('php://input'), true);
if(!$body) json_out(['success'=>false,'error'=>'bad payload']);
if(empty($_SESSION['webauthn_challenge']) || empty($_SESSION['webauthn_user'])) json_out(['success'=>false,'error'=>'no session challenge']);

$challenge = base64url_decode($_SESSION['webauthn_challenge']);
$userId = $_SESSION['webauthn_user'];

$clientDataJSON = base64url_decode($body['clientDataJSON'] ?? '');
$attestationObject = base64url_decode($body['attestationObject'] ?? '');
$rawId = base64url_decode($body['rawId'] ?? '');

// NOTE: This file stores raw credential data. For production, use a WebAuthn library to:
// 1) parse and verify attestationObject
// 2) extract credentialPublicKey and signCount
// 3) validate challenge, origin and rpId
//
// For demo, store raw values.
$ins = $pdo->prepare("INSERT INTO webauthn_credentials (user_id, cred_id, public_key, sign_count, transports) VALUES (?,?,?,?,?)");
$publicKeyRaw = $attestationObject;
$signCount = 0;
$transports = null;
$ins->execute([$userId, $rawId, $publicKeyRaw, $signCount, $transports]);

json_out(['success'=>true,'message'=>'credential stored (demo). Please integrate full verification for production.']);
