<?php
require_once __DIR__ . '/../includes/session.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/functions.php';

$body = json_decode(file_get_contents('php://input'), true);
$username = $body['username'] ?? null;
$userId = null;
if($username){
  $stmt = $pdo->prepare("SELECT id FROM users WHERE username=?");
  $stmt->execute([$username]);
  $r = $stmt->fetch(PDO::FETCH_ASSOC);
  if(!$r) json_out(['success'=>false,'error'=>'no such user']);
  $userId = $r['id'];
}

$challenge = random_bytes(32);
$_SESSION['webauthn_challenge'] = base64url_encode($challenge);

if($userId){
  $stmt = $pdo->prepare("SELECT cred_id FROM webauthn_credentials WHERE user_id=?");
  $stmt->execute([$userId]);
} else {
  $stmt = $pdo->query("SELECT cred_id FROM webauthn_credentials");
}
$allow = [];
while($row = $stmt->fetch(PDO::FETCH_ASSOC)){
  $allow[] = ['type'=>'public-key','id'=>base64url_encode($row['cred_id'])];
}

$options = ['challenge' => base64url_encode($challenge), 'timeout'=>60000, 'rpId'=> $_SERVER['SERVER_NAME'], 'allowCredentials'=>$allow, 'userVerification'=>'preferred'];
json_out(['success'=>true,'options'=>$options]);
