# WebAuthn + Face Fallback — Demo Project

This archive contains a complete **starter** project implementing:
- WebAuthn (primary) registration & login (PHP + JS)
- Face-recognition fallback microservice (Python Flask) for optional verification
- MariaDB schema

IMPORTANT:
- This repo includes *working client-side WebAuthn code*, and PHP server endpoints with clear placeholders.
- **Cryptographic verification of attestation/assertions must be done with a WebAuthn PHP library before using in production.**
  See section below for quick setup.

## Contents
- `public/` — HTML/JS/CSS (served by your web server)
- `api/` — PHP endpoints (`register_start.php`, `register_finish.php`, `login_start.php`, `login_finish.php`)
- `includes/` — DB + helpers + config
- `sql/schema.sql` — SQL to create DB/tables
- `face-service/` — Python Flask microservice for face embedding register/verify
- `composer.json` — minimal composer file (run `composer require web-auth/webauthn-lib` to install WebAuthn library)

## Quickstart (local testing)
1. Create the database:
    - Edit `includes/config.php` (DB credentials)
    - Run `mysql -u root -p < sql/schema.sql`
2. Install composer libraries:
    - `composer install`
    - `composer require web-auth/webauthn-lib` (recommended)
3. Serve the `public/` directory via PHP built-in server for testing:
    - `php -S localhost:8443 -t public/`
    - Open https://localhost:8443/register.html (note: WebAuthn requires secure context — localhost is allowed in many browsers)
4. Start face service (optional):
    - `cd face-service`
    - `pip install -r requirements.txt`
    - `python app.py`

## Notes / Production
- Use HTTPS with a valid certificate for public deployments.
- Replace minimal placeholder verification code in `api/register_finish.php` and `api/login_finish.php` with full verification using `web-auth/webauthn-lib` or similar.
- Add CSRF, rate-limiting, proper session handling, and secure cookie flags.

